//
//  CMS_Langs.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 06/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*

 CMS_Langs
 
 string do_lang(string strName, array parameters) -- lookup a translation string, with a list of parameters for it
 
 */

import UIKit
import Foundation

class CMS_Langs: NSObject {
    
    /**
     *  returns localized value of the supplied key string
     *
     *  @param key key to search in localization.strings
     *
     *  @return returns matching localized value of the key from localization.strings
     */
    class func do_lang(key: String) -> String {
        return NSLocalizedString(key, "")
    }
    
    /**
     *  returns localized value of the supplied key string
     *
     *  @param strName    source string
     *  @param parameters parameters to be replaced in string
     *
     *  @return returns matching localized value of the string replaced with parameters from localization.strings
     */
    class func do_lang(strName: String, parameters: [AnyObject]) -> String {
        return NSLocalizedString(CMS_Strings.stringWithFormat(strName, array: parameters), "")
    }

}